// icontlbr2.js

class IconToolbar2 {
    constructor(elementId, config) {
        this.toolbar = document.getElementById(elementId);
                
        if (!this.toolbar) {
            throw new Error(`Toolbar element with ID '${elementId}' not found`);
        }
    
        this.config = config || {};
        this.icons = this.config.icons || [];
        this.menuItems = this.config.menuItems || [];
        
        this.content = this.toolbar.querySelector('.icontlbr2-content');
        if (!this.content) {
            this.content = document.createElement('div');
            this.content.className = 'icontlbr2-content';
            this.toolbar.appendChild(this.content);
        }
    
        this.isMenuOpen = false;
        this.init();
    }
    
    init() {
        // Clear existing content
        this.content.innerHTML = '';
        
        // Add regular icons
        this.icons.forEach(icon => {
            const button = document.createElement('button');
            button.className = 'icontlbr2-icon';
            button.innerHTML = icon.symbol;
            button.setAttribute('aria-label', icon.label);
    
            // Add tooltip div
            const tooltip = document.createElement('div');
            tooltip.className = 'icontlbr2-tooltip';
            tooltip.textContent = icon.label;
            button.appendChild(tooltip);
    
            button.onclick = (e) => {
                e.stopPropagation();
                icon.action();
                if (icon.feedback) {
                    this.showFeedback(button, icon.feedback);
                }
            };
            this.content.appendChild(button);
        });
    
        // Add menu if there are menu items
        if (this.menuItems.length > 0) {
            this.addMenu();
        }
    }

    addMenu() {
        const menuContainer = document.createElement('div');
        menuContainer.className = 'icontlbr2-menu';

        const menuButton = document.createElement('button');
        menuButton.className = 'icontlbr2-icon';
        menuButton.innerHTML = '⋮';
        menuButton.setAttribute('aria-label', 'More options');

        const dropdown = document.createElement('div');
        dropdown.className = 'icontlbr2-dropdown';

        this.menuItems.forEach(item => {
            const button = document.createElement('button');
            button.className = 'icontlbr2-dropdown-item';
            button.textContent = item.text;
            button.onclick = (e) => {
                e.stopPropagation();
                item.action();
                this.closeMenu();
            };
            dropdown.appendChild(button);
        });

        menuButton.onclick = (e) => {
            e.stopPropagation();
            this.toggleMenu();
        };

        menuContainer.appendChild(menuButton);
        menuContainer.appendChild(dropdown);
        this.content.appendChild(menuContainer);

        // Close menu when clicking outside
        document.addEventListener('click', () => {
            this.closeMenu();
        });
    }

    showFeedback(element, message) {
        element.setAttribute('data-feedback', message);
        element.classList.add('with-feedback');
        setTimeout(() => {
            element.classList.remove('with-feedback');
        }, 2000);
    }

    toggleMenu() {
        const dropdown = this.toolbar.querySelector('.icontlbr2-dropdown');
        this.isMenuOpen = !this.isMenuOpen;
        dropdown.classList.toggle('active', this.isMenuOpen);
    }

    closeMenu() {
        const dropdown = this.toolbar.querySelector('.icontlbr2-dropdown');
        if (dropdown) {
            this.isMenuOpen = false;
            dropdown.classList.remove('active');
        }
    }
}