import appState from './state.js';
import { viewManager } from './viewManager.js';

// Initialize application
async function initializeApp() {
    console.log('Initializing app...');
    
    // Load toolbar
    try {
        const response = await fetch('share/toolbar.html');
        const html = await response.text();
        document.getElementById('toolbar-container').innerHTML = html;

        // Set up toolbar navigation
        document.querySelectorAll('.toolbar nav a').forEach(link => {
            link.addEventListener('click', (e) => {
                e.preventDefault(); // Always prevent default first
                
                const href = link.getAttribute('href');
                
                // If it's an external link (has target="_blank" or full URL), open in new window
                if (link.getAttribute('target') === '_blank' || href.startsWith('http')) {
                    window.open(href, '_blank');
                    return;
                }
                
                // Otherwise handle as internal view
                const viewName = href.split('/')[1].replace('.html', '');
                viewManager.loadView(viewName);
            });
        });

        // Initialize 

        // Load initial view
        viewManager.loadView('grpedit');
    } catch (error) {
        showMessageBar('error','Error initializing application: ' + error.message, 'error');
    }
}

// Start the application when DOM is ready
document.addEventListener('DOMContentLoaded', initializeApp);

// Export for potential external use
export { initializeApp };