// Application State Management
class AppState {
    constructor() {
        this.currentView = null;
        this.dnaData = null;
        this.observers = {};
    }

    // Data management methods
    setDNAData(data) {
        this.dnaData = data;
        this.notifyObservers('dnaData', data);
    }

    getDNAData() {
        return this.dnaData;
    }

    // Observer pattern implementation
    addObserver(event, callback) {
        if (!this.observers[event]) {
            this.observers[event] = [];
        }
        this.observers[event].push(callback);
    }

    removeObserver(event, callback) {
        if (this.observers[event]) {
            this.observers[event] = this.observers[event].filter(cb => cb !== callback);
        }
    }

    notifyObservers(event, data) {
        if (this.observers[event]) {
            this.observers[event].forEach(callback => callback(data));
        }
    }
}

// Create and export a singleton instance
const appState = new AppState();

// Export as default and named export
export default appState;
export { appState };