// Load shared dependencies
export async function loadSharedDependencies() {
    // Load Google Fonts
    const fontLink = document.createElement('link');
    fontLink.href = 'https://fonts.googleapis.com/css2?family=Source+Code+Pro:wght@400;500&display=swap';
    fontLink.rel = 'stylesheet';
    document.head.appendChild(fontLink);

    // Load shared CSS
    const cssFiles = [
        'share/toolbar.css',
        'share/dnarow.css'
    ];

    cssFiles.forEach(file => {
        if (!document.querySelector(`link[href*="${file}"]`)) {
            const link = document.createElement('link');
            link.rel = 'stylesheet';
            link.href = file;
            document.head.appendChild(link);
        }
    });

    // Load jQuery
    if (typeof jQuery === 'undefined') {
        const script = document.createElement('script');
        script.src = 'share/jquery.min.js';
        await new Promise((resolve, reject) => {
            script.onload = resolve;
            script.onerror = reject;
            document.head.appendChild(script);
        });
    }

    // Load other shared scripts
    const scripts = [
        'share/elems.js',
        'js/msgbar.js',
        'share/dnaparser.js'
    ];

    for (const file of scripts) {
        if (!document.querySelector(`script[src*="${file}"]`)) {
            await new Promise((resolve, reject) => {
                const script = document.createElement('script');
                script.src = file;
                script.onload = resolve;
                script.onerror = reject;
                document.head.appendChild(script);
            });
        }
    }
}