// elems.js - share elements for Bernie UI
function loadToolbar(placeholderId, toolbarPath) {
    const toolbarPlaceholder = document.getElementById(placeholderId);
    if (!toolbarPlaceholder) {
        console.error(`Toolbar placeholder with ID "${placeholderId}" not found.`);
        return;
    }

    fetch(toolbarPath)
        .then(response => response.text())
        .then(html => {
            toolbarPlaceholder.innerHTML = html;
            console.log("Toolbar loaded successfully.");

            // Highlight the current view
            highlightCurrentView();
        })
        .catch(error => console.error("Error loading toolbar:", error));
}

function highlightCurrentView() {
    // Get the current URL path
    const currentPath = window.location.pathname;

    // Find all links in the toolbar
    const toolbarLinks = document.querySelectorAll(".toolbar nav a");

    // Loop through links and manage the "current-view" class
    toolbarLinks.forEach(link => {
        const linkPath = new URL(link.href, window.location.origin).pathname;

        // Add "current-view" class to the matching link
        if (currentPath === linkPath) {
            link.classList.add("current-view");
        } else {
            link.classList.remove("current-view"); // Remove it from non-active links
        }
    });
}