#!/bin/bash
SIMD_DATA_DIR="/var/lib/simd"
SIMQ_RELEASE_DIR="/usr/local/simq"
VERBOSE=0
#---------------------------------------------------------------
# Function to echo messages in verbose mode
#---------------------------------------------------------------
vecho() {
    if [ $VERBOSE -eq 1 ]; then
        echo "$@"
    fi
}
#------------------------------------------------
# Process command-line options
#------------------------------------------------
while getopts "v" opt; do
    case $opt in
    v)
        VERBOSE=1
        ;;
    *)
        echo "Usage: $0 [-v]" >&2
        exit 1
        ;;
    esac
done

#--------------------------------------------------------------------------------------------
# Ensure the script is running as root. It needs to be root because there are commands that 
# create users and groups.
#--------------------------------------------------------------------------------------------
if [ "$EUID" -ne 0 ]; then
    echo "This script must be run as root. Please use sudo or run as root user."
    exit 1
fi

#------------------------------------------------
# First remove all the service related stuff...
#------------------------------------------------
vecho "Removing system service: simd..."
systemctl stop simd
systemctl disable simd
vecho "Removing simd service files..."
rm /etc/systemd/system/simd.service
rm -rf /etc/simd

#----------------------------------------------------------------
# Remove the home directory of the simd user if it exists
#----------------------------------------------------------------
vecho "Removing user and group: simd..."
userdel simd
groupdel simd
if [ -d "/var/empty" ]; then
    vecho "Removing home directory of simd user..."
    rm -rf /var/empty
fi

#----------------------------------------------------------------
# Attempt to remove the home directory of the simd user if possible
#----------------------------------------------------------------
if [ -d "/var/empty" ]; then
    # Test if the directory is writable
    if touch /var/empty/testfile &>/dev/null; then
        rm -rf /var/empty
        vecho "Removed /var/empty"
    fi
fi

#------------------------------------------------
# reset system daeomons
#------------------------------------------------
vecho "systemd daemon-reload..."
systemctl daemon-reload

#------------------------------------------------
# Remove the simd files
#------------------------------------------------
vecho "Removing simd data files..."
rm -rf "${SIMQ_RELEASE_DIR}"
rm -rf "${SIMD_DATA_DIR}"

vecho "Uninstall complete."